/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.hover;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.hover.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonAnnotationHover
implements IAnnotationHover {
    private boolean fShowLineNumber;

    public CommonAnnotationHover() {
        this(false);
    }

    public CommonAnnotationHover(boolean showLineNumber) {
        this.fShowLineNumber = showLineNumber;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        Set<Annotation> javaAnnotations = this.getAnnotationsForLine(sourceViewer, lineNumber);
        if (javaAnnotations != null) {
            if (javaAnnotations.size() == 1) {
                Annotation annotation = javaAnnotations.iterator().next();
                String message = annotation.getText();
                if (!StringUtil.isEmpty((String)message)) {
                    return this.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                for (Annotation annotation : javaAnnotations) {
                    String message = annotation.getText();
                    if (StringUtil.isEmpty((String)message)) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return this.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return this.formatMultipleMessages(messages);
                }
            }
        }
        if (this.fShowLineNumber && lineNumber > -1) {
            return MessageFormat.format(Messages.CommonAnnotationHover_lineNumber, Integer.toString(lineNumber + 1));
        }
        return null;
    }

    protected boolean isIncluded(Annotation annotation) {
        return true;
    }

    protected String formatSingleMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog((StringBuffer)buffer);
        HTMLPrinter.addParagraph((StringBuffer)buffer, (String)HTMLPrinter.convertToHTMLContent((String)message));
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        return buffer.toString();
    }

    protected String formatMultipleMessages(List messages) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog((StringBuffer)buffer);
        HTMLPrinter.addParagraph((StringBuffer)buffer, (String)HTMLPrinter.convertToHTMLContent((String)Messages.CommonAnnotationHover_multipleMarkersMessage));
        HTMLPrinter.startBulletList((StringBuffer)buffer);
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            HTMLPrinter.addBullet((StringBuffer)buffer, (String)HTMLPrinter.convertToHTMLContent((String)((String)e.next())));
        }
        HTMLPrinter.endBulletList((StringBuffer)buffer);
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        return buffer.toString();
    }

    private boolean isRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                return line == document.getLineOfOffset(position.getOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    private IAnnotationModel getAnnotationModel(ISourceViewer viewer) {
        if (viewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 extension = (ISourceViewerExtension2)viewer;
            return extension.getVisualAnnotationModel();
        }
        return viewer.getAnnotationModel();
    }

    private boolean isDuplicateAnnotation(Map<Position, Object> messagesAtPosition, Position position, String message) {
        if (messagesAtPosition.containsKey(position)) {
            Object value = messagesAtPosition.get(position);
            if (message.equals(value)) {
                return true;
            }
            if (value instanceof List) {
                List messages = (List)value;
                if (messages.contains(message)) {
                    return true;
                }
                messages.add(message);
            } else {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.add(value);
                messages.add(message);
                messagesAtPosition.put(position, messages);
            }
        } else {
            messagesAtPosition.put(position, message);
        }
        return false;
    }

    private boolean includeAnnotation(Annotation annotation, Position position, Map<Position, Object> messagesAtPosition) {
        if (!this.isIncluded(annotation)) {
            return false;
        }
        String text = annotation.getText();
        return text != null && !this.isDuplicateAnnotation(messagesAtPosition, position, text);
    }

    private Set<Annotation> getAnnotationsForLine(ISourceViewer viewer, int line) {
        IAnnotationModel model = this.getAnnotationModel(viewer);
        if (model == null) {
            return null;
        }
        IDocument document = viewer.getDocument();
        TreeSet<Annotation> javaAnnotations = new TreeSet<Annotation>(new SimpleMarkerAnnotationComparator());
        HashMap<Position, Object> messagesAtPosition = new HashMap<Position, Object>();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation2 = (Annotation)iterator.next();
            Position position = model.getPosition(annotation2);
            if (position == null || !this.isRulerLine(position, document, line)) continue;
            if (annotation2 instanceof AnnotationBag) {
                AnnotationBag bag = (AnnotationBag)annotation2;
                for (Annotation annotation2 : bag) {
                    position = model.getPosition(annotation2);
                    if (position == null || !this.includeAnnotation(annotation2, position, messagesAtPosition)) continue;
                    javaAnnotations.add(annotation2);
                }
                continue;
            }
            if (!this.includeAnnotation(annotation2, position, messagesAtPosition)) continue;
            javaAnnotations.add(annotation2);
        }
        return javaAnnotations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleMarkerAnnotationComparator
    implements Comparator<Annotation> {
        private SimpleMarkerAnnotationComparator() {
        }

        @Override
        public int compare(Annotation o1, Annotation o2) {
            if (o1 instanceof SimpleMarkerAnnotation && o2 instanceof SimpleMarkerAnnotation) {
                IMarker m1 = ((SimpleMarkerAnnotation)o1).getMarker();
                IMarker m2 = ((SimpleMarkerAnnotation)o2).getMarker();
                if (m1 != null && m2 != null) {
                    int pos1 = m1.getAttribute("charStart", -1);
                    int pos2 = m2.getAttribute("charStart", -1);
                    if (pos1 > -1 && pos2 > -1) {
                        return pos1 - pos2;
                    }
                    pos1 = m1.getAttribute("lineNumber", -1);
                    pos2 = m2.getAttribute("lineNumber", -1);
                    if (pos1 > -1 && pos2 > -1) {
                        return pos1 - pos2;
                    }
                }
            }
            return 0;
        }
    }
}

